
IF  EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_FECHA_FILIAL_MES_ACERTO_FLUTUANTE]') 
						AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_FECHA_FILIAL_MES_ACERTO_FLUTUANTE]
GO 

-- P_EST_FECHA_FILIAL_MES_ACERTO_FLUTUANTE 900,2015,6, 4833461.98 ,1
-- P_EST_FECHA_FILIAL_MES_ACERTO_FLUTUANTE 900,2015,6, 6417300.12 ,0

-- P_EST_FECHA_FILIAL_MES_ACERTO_FLUTUANTE 999,2015,6,  1590795.56 ,1
CREATE PROCEDURE P_EST_FECHA_FILIAL_MES_ACERTO_FLUTUANTE(@FILIAL INT,@ANO INT, @MES INT, @VALOR FLOAT, @Final int=1)
AS
 
DECLARE @RAT	FLOAT
DECLARE @TOT	FLOAT 
	
	if @Final=1
	begin

		set @TOT = (SELECT  SUM(A.QT_EST_FLUT * A.VLR_CUSTO_MD_FLUTUANTE ) 
										FROM 
											EST_FECHA  A 
											INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA C ON 
											A.CD_EMP =C.CD_EMP AND
											A.CD_PROD =C.CD_PROD
										WHERE 
											A.CD_EMP=1
											AND A.CD_FILIAL =@FILIAL
											AND NOT C.CD_ARV_MERC_LINHA IN (0,5,99,104,105,106,116,117)
											AND A.ANO_FECHA=@ANO
											AND A.MES_FECHA=@MES )   
	end
	else
	begin
			set @TOT = (SELECT  SUM(A.QT_INI_FLUT * A.VLR_INI_FLUT ) 
										FROM 
											EST_FECHA  A 
											INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA C ON 
											A.CD_EMP =C.CD_EMP AND
											A.CD_PROD =C.CD_PROD
										WHERE 
											A.CD_EMP=1
											AND A.CD_FILIAL =@FILIAL
											AND NOT C.CD_ARV_MERC_LINHA IN (0,5,99,104,105,106,116,117)
											AND A.ANO_FECHA=@ANO
											AND A.MES_FECHA=@MES ) 

	end
	
	SET @RAT =@VALOR-@TOT 
--SELECT  @VALOR, @TOT, @RAT 
if @Final=1
	begin
		UPDATE A SET
			VLR_CUSTO_MD_FLUTUANTE = ( A.VLR_CUSTO_MD_FLUTUANTE+ ((A.VLR_CUSTO_MD_FLUTUANTE/@TOT)  *@RAT)) 
		FROM 
			EST_FECHA  A 
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA C ON 
			A.CD_EMP  =C.CD_EMP AND
			A.CD_PROD =C.CD_PROD
		WHERE 
			A.CD_EMP=1
			AND A.CD_FILIAL=@FILIAL
			AND NOT C.CD_ARV_MERC_LINHA IN (0,5,99,104,105,106,116,117)
			AND A.ANO_FECHA=@ANO
			AND A.MES_FECHA=@MES
			and A.QT_EST_FLUT <>0
	END
ELSE
	BEGIN

		UPDATE A SET
			VLR_INI_FLUT = ( A.VLR_INI_FLUT+ ((A.VLR_INI_FLUT/@TOT)  *@RAT)) 
		FROM 
			EST_FECHA  A 
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA C ON 
			A.CD_EMP  =C.CD_EMP AND
			A.CD_PROD =C.CD_PROD
		WHERE 
			A.CD_EMP=1
			AND A.CD_FILIAL=@FILIAL
			AND NOT C.CD_ARV_MERC_LINHA IN (0,5,99,104,105,106,116,117)
			AND A.ANO_FECHA=@ANO
			AND A.MES_FECHA=@MES
			and A.QT_INI_FLUT <>0
	END